from py_pli.pylib import GlobalVar
from fleming.common.firmware_util import *
from urpc_enum.moverparameter import MoverParameter


# Node Endpoint ########################################################################################################

nodes = {
    'eef'       : {'id':0x0008, 'delay':5},
    'mc6'       : {'id':0x0010, 'delay':1},
    'mc6_stk'   : {'id':0x0028, 'delay':1},
    'fmb'       : {'id':0x0018, 'delay':1},
    'pmc'       : {'id':0x00F0, 'delay':1},
    'pmc1'      : {'id':0x00F1, 'delay':1},
    'pmc2'      : {'id':0x00F2, 'delay':1},
    'pmc3'      : {'id':0x00F3, 'delay':1},
}

# Mover Endpoint ########################################################################################################

movers = {

# Alternative Naming for MC6 Tests
    'mc6m1'     : {'id':0x0110},  # Filder Module Slider
    'mc6m2'     : {'id':0x0111},  # US Lum Focus Mover
    'mc6m3'     : {'id':0x0112},  # Focus Mover
    'mc6m4'     : {'id':0x0113},  # Bottom Light Director
    'mc6m5'     : {'id':0x0114},  # Plate Door
    'mc6m6'     : {'id':0x0115},  # Excitation Light Selector

}


def get_mover_endpoint(mover_name):
    can_id = movers[mover_name]['id']
    endpoint = URPCFunctions.instance.endPointsDic.get(can_id)
    if endpoint is None:
        endpoint = URPCFunctions.instance.endPointCreator.createEndPoint(can_id, URPCInterfaceType.MoverEndpoint)
    return endpoint
    
# Initialization #######################################################################################################

async def init(*endpoints):
    for endpoint in endpoints:
        if endpoint in nodes:
            await start_firmware(endpoint)
        if endpoint in movers:
            mover = get_mover_endpoint(endpoint)
            if endpoint == 'mc6m3' or endpoint == 'mc6m4' or endpoint == 'mc6m5' or endpoint == 'mc6m6' :
                await mover.SetProfile(
                    handle=0, speed=30000, accel=300000, decel=300000, uSteps=256, drivePower=40, holdPower=0, drivePowerHoldTime=1000, drivePowerFallTime=1000, timeout=1
                )
                await mover.UseProfile(0, timeout=1)
                await mover.SetParameter(MoverParameter.HomeSearchDirection,               0, timeout=1)
                await mover.SetParameter(MoverParameter.HomeMaxDistance,             1000000, timeout=1)
                await mover.SetParameter(MoverParameter.HomeMaxReverseDistance,      1000000, timeout=1)
                await mover.SetParameter(MoverParameter.HomeExtraReverseDistance,          0, timeout=1)
                await mover.SetParameter(MoverParameter.HomeCalibrationSpeed,          10000, timeout=1)
                await mover.SetParameter(MoverParameter.HomePosition,             0x7FFFFFFF, timeout=1)
                await mover.SetParameter(MoverParameter.HomeSensorEnable,               0x01, timeout=1)
                await mover.SetParameter(MoverParameter.MovementDirection,                 1, timeout=1)
                await mover.SetConfigurationStatus(1, timeout=1)
            else:
                await mover.SetProfile(
                    handle=0, speed=30000, accel=300000, decel=300000, uSteps=256, drivePower=40, holdPower=0, drivePowerHoldTime=1000, drivePowerFallTime=1000, timeout=1
                )
                await mover.UseProfile(0, timeout=1)
                await mover.SetParameter(MoverParameter.HomeSearchDirection,               0, timeout=1)
                await mover.SetParameter(MoverParameter.HomeMaxDistance,             1000000, timeout=1)
                await mover.SetParameter(MoverParameter.HomeMaxReverseDistance,      1000000, timeout=1)
                await mover.SetParameter(MoverParameter.HomeExtraReverseDistance,          0, timeout=1)
                await mover.SetParameter(MoverParameter.HomeCalibrationSpeed,          10000, timeout=1)
                await mover.SetParameter(MoverParameter.HomePosition,             0x7FFFFFFF, timeout=1)
                await mover.SetParameter(MoverParameter.HomeSensorEnable,               0x01, timeout=1)
                await mover.SetParameter(MoverParameter.EncoderMode,                       1, timeout=1)
                await mover.SetParameter(MoverParameter.EncoderCorrectionFactor,      25.600, timeout=1)
                await mover.SetParameter(MoverParameter.MaxEncoderDeviation,            1024, timeout=1)
                await mover.SetParameter(MoverParameter.MovementDirection,                 1, timeout=1)
                await mover.SetConfigurationStatus(1, timeout=1)
        await asyncio.sleep(0.5)

async def mc6_test_script():

    #Test script for MC6
    #This scripts checks the following interfaces
    #M1 to M6
    #ENC1 and ENC2      -> 3V3, GND, Index and A/B 
    #PWM1 to PWM4
    #REF1 to REF12      -> 3V3, GND and Input
    #SH                 -> 3V3, GND, PWM1 and I2C2
    #EXP                -> 3V3, GND, PWM3, PWM4, ADC In2, ADC In3 and I2C1
    #CAN
    #Internal ADC
    #USB interface is tested prior during programming of MC6.
    
    #Mover tests seem odd because ENC1 and ENC2 are used to check movement, but are only supportet for M1 and M2 in MC6 firmware. Dummy movement of M1 or M2 is needed.
    #Mover test of M2 is special because M2 is electrically connectet to motor 1 on MC6 tester but ENC2 is mounted to motor 2. Dummy movement of M1 and physical movement of M4 is needed in addition to physical movement of M2.
    #Test of ENC1 and ENC2 index is slow because index signal can not be used for homing. For repeatebility it is implemented in a while loop with small movements of motor 1 and 2.

    fmb = get_node_endpoint('fmb')

    # Reset the ground control stop button status at the beginning of the test.
    GlobalVar.set_stop_gc(False)
    # Send information and test results to ground control, that will be printed in the output text box.

    await start_firmware('fmb')
    await fmb.SetDigitalOutput(FMBDigitalOutput.PSUON, 0)       # Base Tester Power = ON (active low)
    
    try:
        
        await asyncio.sleep(1)

        mov1 = get_mover_endpoint('mc6m1')
        mov2 = get_mover_endpoint('mc6m2')
        mov3 = get_mover_endpoint('mc6m3')
        mov4 = get_mover_endpoint('mc6m4')
        mov5 = get_mover_endpoint('mc6m5')
        mov6 = get_mover_endpoint('mc6m6')
        mc6 = get_node_endpoint('mc6')
    
        mc6test_error = 0
    
        await send_gc_msg(f"Start MC6 Test")
        #Test all movers
        #Test mover 1 and ENC1 
        #Test ENC1 index
        await init('mc6', 'mc6m1')
        await mov1.SetPosition(0)
        await asyncio.sleep(.1)
        move_value = 40000
        if (await mc6.GetDigitalInput(12))[0] == 1:
            await mov1.Move(1000)
            if (await mc6.GetDigitalInput(12))[0] == 1:
                mc6test_error = 1
                await send_msg(json.dumps({'result': f"ENC1 Index error"}))
                await send_msg(json.dumps({'result': f"FAILED ENC1 Index Test"}))
        x = 0
        while x == 0:
            x = (await mc6.GetDigitalInput(12))[0]
            await mov1.Move(move_value)
            move_value = move_value + 25
            if move_value > 93000:
                mc6test_error = 1
                await send_msg(json.dumps({'result': f"ENC1 Index error"}))
                await send_msg(json.dumps({'result': f"FAILED ENC1 Index Test"}))
                break
        await mov1.Stop(1,2)
        await asyncio.sleep(.1)
        if mc6test_error == 0:
            await send_msg(json.dumps({'result': f"PASSED ENC1 Index Test"}))
        
        await mc6.Reset()
        await asyncio.sleep(.1)
    
        await init('mc6', 'mc6m1')
        await mov1.SetPosition(0)
        current_position = (await mov1.GetPosition())[0]
        if not current_position == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"M1 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M1 Test"}))
        await asyncio.gather(
            mov1.Move(5120))
        await asyncio.sleep(.1)
        current_position = (await mov1.GetPosition())[0]
        if not current_position == 5120:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"M1 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M1 Test"}))
        await asyncio.gather(
            mov1.Move(0))
        await asyncio.sleep(.1)
        current_position = (await mov1.GetPosition())[0]
        if not current_position == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"M1 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M1 Test"}))
        await asyncio.sleep(.1)
        if mc6test_error == 0:
            await send_msg(json.dumps({'result': f"PASSED M1 Test"}))
        await mc6.Reset()
        await asyncio.sleep(.1)
    
        #Test mover 2
        await init('mc6')
        await mc6.ConfigurePWMOutput(0,1000,1000,10)
        await mc6.EnablePWMOutput(0,1)  #enable PWM1
        await asyncio.sleep(.1)
    
        await init('mc6', 'mc6m2')
        await init('mc6', 'mc6m1')
        await init('mc6', 'mc6m4')
        await mov4.SetPosition(0)
        await mov2.SetPosition(0)
        await mov1.SetPosition(0)
        current_position = (await mov1.GetPosition())[0]
        if not current_position == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"M2 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M2 Test"}))
        await asyncio.gather(
            mov2.Move(5120),
            mov4.Move(5120),
            mov1.Move(5120))
        await asyncio.sleep(.1)
        current_position = (await mov1.GetPosition())[0]
        if not current_position == 5120:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"M2 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M2 Test"}))
        await asyncio.gather(
            mov4.Move(0),
            mov2.Move(0),
            mov1.Move(0))
        await asyncio.sleep(.1)
        current_position = (await mov1.GetPosition())[0]
        if not current_position == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"M2 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M2 Test"}))
        await asyncio.sleep(.1)
        if mc6test_error == 0:
            await send_msg(json.dumps({'result': f"PASSED M2 Test"}))
        await mc6.Reset()
        await asyncio.sleep(.1)
        
        #Test Mover 3
        await init('mc6')
        await mc6.ConfigurePWMOutput(1,1000,1000,10)
        await mc6.EnablePWMOutput(1,1)  #enable PWM2
        await asyncio.sleep(.1)

        
        await init('mc6', 'mc6m3')
        await init('mc6', 'mc6m1')
        await mov3.SetPosition(0)
        await mov1.SetPosition(0)
        current_position = (await mov1.GetPosition())[0]
        if not current_position == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"M3 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M3 Test"}))
        await asyncio.gather(
            mov3.Move(5120),
            mov1.Move(5120))
        await asyncio.sleep(.1)
        current_position = (await mov1.GetPosition())[0]
        if not current_position == 5120:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"M3 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M3 Test"}))
        await asyncio.gather(
            mov3.Move(0),
            mov1.Move(0))
        await asyncio.sleep(.1)
        current_position = (await mov1.GetPosition())[0]
        if not current_position == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"M3 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M3 Test"}))
        await asyncio.sleep(.1)
        if mc6test_error == 0:
            await send_msg(json.dumps({'result': f"PASSED M3 Test"}))
        await mc6.Reset()
        await asyncio.sleep(.1)
        
        
        #Test Mover 4 and ENC2 
        #Test ENC2 Index
        await init('mc6', 'mc6m4')
        await mov4.SetPosition(0)
        await asyncio.sleep(.1)
        move_value = 40000
        if (await mc6.GetDigitalInput(15))[0] == 1:
            await mov1.Move(1000)
            if (await mc6.GetDigitalInput(15))[0] == 1:
                mc6test_error = 1
                await send_msg(json.dumps({'result': f"ENC2 Index error"}))
                await send_msg(json.dumps({'result': f"FAILED ENC2 Index Test"}))
        x = 0
        while x == 0:
            x = (await mc6.GetDigitalInput(15))[0]
            await mov4.Move(move_value)
            move_value = move_value + 25
            if move_value > 93000:
                mc6test_error = 1
                await send_msg(json.dumps({'result': f"ENC2 Index error"}))
                await send_msg(json.dumps({'result': f"FAILED ENC2 Index Test"}))
                break
        await mov4.Stop(1,2)
        await asyncio.sleep(.1)
        if mc6test_error == 0:
            await send_msg(json.dumps({'result': f"PASSED ENC2 Index Test"}))
        await mc6.Reset()
        await asyncio.sleep(.1)
        
        await init('mc6', 'mc6m4')
        await init('mc6', 'mc6m2')
        await mov4.SetPosition(0)
        await mov2.SetPosition(0)
        current_position = (await mov2.GetPosition())[0]
        if not current_position == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"M4 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M4 Test"}))
        await asyncio.gather(
            mov4.Move(5120),
            mov2.Move(5120))
        await asyncio.sleep(.1)
        current_position = (await mov2.GetPosition())[0]
        if not current_position == 5120:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"M4 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M4 Test"}))
        await asyncio.gather(
            mov4.Move(0),
            mov2.Move(0))
        await asyncio.sleep(.1)
        current_position = (await mov2.GetPosition())[0]
        if not current_position == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"M4 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M4 Test"}))
        await asyncio.sleep(.1)
        if mc6test_error == 0:
            await send_msg(json.dumps({'result': f"PASSED M4 Test"}))
        await mc6.Reset()
        await asyncio.sleep(.1)
        
        #Test Mover 5
        await init('mc6')
        await mc6.ConfigurePWMOutput(2,1000,1000,10)
        await mc6.EnablePWMOutput(2,1)  #enable PWM3
        await asyncio.sleep(.1)

        await init('mc6', 'mc6m5')
        await init('mc6', 'mc6m2')
        await mov5.SetPosition(0)
        await mov2.SetPosition(0)
        current_position = (await mov2.GetPosition())[0]
        if not current_position == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"M5 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M5 Test"}))
        await asyncio.gather(
            mov5.Move(5120),
            mov2.Move(5120))
        await asyncio.sleep(.1)
        current_position = (await mov2.GetPosition())[0]
        if not current_position == 5120:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"M5 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M5 Test"}))
        await asyncio.gather(
            mov5.Move(0),
            mov2.Move(0))
        await asyncio.sleep(.1)
        current_position = (await mov2.GetPosition())[0]
        if not current_position == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"M5 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M5 Test"}))
        await asyncio.sleep(.1)
        if mc6test_error == 0:
            await send_msg(json.dumps({'result': f"PASSED M5 Test"}))
        await mc6.Reset()
        await asyncio.sleep(.1)
        
        #Test Mover 6
        await init('mc6')
        await mc6.ConfigurePWMOutput(3,1000,1000,10)
        await mc6.EnablePWMOutput(3,1)  #enable PWM4
        await asyncio.sleep(.1)

        
        await init('mc6', 'mc6m6')
        await init('mc6', 'mc6m2')
        await mov6.SetPosition(0)
        await mov2.SetPosition(0)
        current_position = (await mov2.GetPosition())[0]
        if not current_position == 0:
            mc6test_error =1
            await send_msg(json.dumps({'result': f"M6 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M6 Test"}))
        await asyncio.gather(
            mov6.Move(5120),
            mov2.Move(5120))
        await asyncio.sleep(.1)
        current_position = (await mov2.GetPosition())[0]
        if not current_position == 5120:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"M6 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M6 Test"}))
        await asyncio.gather(
            mov6.Move(0),
            mov2.Move(0))
        await asyncio.sleep(.1)
        current_position = (await mov2.GetPosition())[0]
        if not current_position == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"M6 position error"}))
            await send_msg(json.dumps({'result': f"FAILED M6 Test"}))
        await asyncio.sleep(.1)
        if mc6test_error == 0:
            await send_msg(json.dumps({'result': f"PASSED M6 Test"}))
        await mc6.Reset()
        await asyncio.sleep(.1)
        
        
        #Test all REF inputs
        #Test REF1-Ref3
        mc6 = get_node_endpoint('mc6')
        await init('mc6')
        await mc6.SetDigitalOutput(0,1) #enable REFVoltage 1-6
        await mc6.SetDigitalOutput(1,1) #enable REFVoltage 7-12
        
        ref1_val = (await mc6.GetDigitalInput(0))[0] #Test REF1
        if ref1_val == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF1 or PWM1 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        ref2_val = (await mc6.GetDigitalInput(1))[0] #Test REF2
        if ref2_val == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF2 or PWM1 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        ref3_val = (await mc6.GetDigitalInput(2))[0] #Test REF3
        if ref3_val == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF3 or PWM1 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        await mc6.ConfigurePWMOutput(0,1000,1000,10)
        await mc6.EnablePWMOutput(0,1) #enable PWM1 for REF 1-3
        await asyncio.sleep(.1)
        ref1_val = (await mc6.GetDigitalInput(0))[0] #Test REF1
        if ref1_val == 1:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF1 or PWM1 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        ref2_val = (await mc6.GetDigitalInput(1))[0] #Test REF2
        if ref2_val == 1:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF2 or PWM1 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        ref3_val = (await mc6.GetDigitalInput(2))[0] #Test REF3
        if ref3_val == 1:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF3 or PWM1 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        await mc6.EnablePWMOutput(0,0)
        await mc6.ConfigurePWMOutput(0,0,0,10)
        await asyncio.sleep(.1)

        
        #Test REF4-Ref6
        ref4_val = (await mc6.GetDigitalInput(3))[0] #Test REF4
        if ref4_val == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF4 or PWM2 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        ref5_val = (await mc6.GetDigitalInput(4))[0] #Test REF5
        if ref5_val == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF5 or PWM2 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        ref6_val = (await mc6.GetDigitalInput(5))[0] #Test REF6
        if ref6_val == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF6 or PWM2 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        await mc6.ConfigurePWMOutput(1,1000,1000,10)
        await mc6.EnablePWMOutput(1,1) #enable PWM2 for REF 4-6
        await asyncio.sleep(.1)
        ref4_val = (await mc6.GetDigitalInput(3))[0] #Test REF4
        if ref4_val == 1:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF4 or PWM2 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        ref5_val = (await mc6.GetDigitalInput(4))[0] #Test REF5
        if ref5_val == 1:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF5 or PWM2 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        ref6_val = (await mc6.GetDigitalInput(5))[0] #Test REF6
        if ref6_val == 1:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF6 or PWM2 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        await mc6.EnablePWMOutput(1,0)
        await mc6.ConfigurePWMOutput(1,0,0,10)
        await asyncio.sleep(.1)

        
        #Test REF7-Ref9
        
        ref7_val = (await mc6.GetDigitalInput(6))[0] #Test REF7
        if ref7_val == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF7 or PWM3 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        ref8_val = (await mc6.GetDigitalInput(7))[0] #Test REF8
        if ref8_val == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF8 or PWM3 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        ref9_val = (await mc6.GetDigitalInput(8))[0] #Test REF9
        if ref9_val == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF9 or PWM3 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        await mc6.ConfigurePWMOutput(2,1000,1000,10)
        await mc6.EnablePWMOutput(2,1) #enable PWM3 for REF 7-9
        await asyncio.sleep(.1)
        ref7_val = (await mc6.GetDigitalInput(6))[0] #Test REF7
        if ref7_val == 1:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF7 or PWM3 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        ref8_val = (await mc6.GetDigitalInput(7))[0] #Test REF8
        if ref8_val == 1:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF8 or PWM3 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        ref9_val = (await mc6.GetDigitalInput(8))[0] #Test REF9
        if ref9_val == 1:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF9 or PWM3 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        await mc6.EnablePWMOutput(2,0)
        await mc6.ConfigurePWMOutput(2,0,0,10)
        await asyncio.sleep(.1)

        
        #Test REF10-Ref12
        ref10_val = (await mc6.GetDigitalInput(9))[0] #Test REF10
        if ref10_val == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF10 or PWM4 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        ref11_val = (await mc6.GetDigitalInput(10))[0] #Test REF11
        if ref11_val == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF11 or PWM4 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        ref12_val = (await mc6.GetDigitalInput(11))[0] #Test REF12
        if ref12_val == 0:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF12 or PWM4 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        await mc6.ConfigurePWMOutput(3,1000,1000,10)
        await mc6.EnablePWMOutput(3,1) #enable PWM4 for REF 10-12
        await asyncio.sleep(.1)
        ref10_val = (await mc6.GetDigitalInput(9))[0] #Test REF10
        if ref10_val == 1:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF10 or PWM4 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        ref11_val = (await mc6.GetDigitalInput(10))[0] #Test REF11
        if ref11_val == 1:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF11 or PWM4 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        ref12_val = (await mc6.GetDigitalInput(11))[0] #Test REF12
        if ref12_val == 1:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"REF12 or PWM4 error"}))
            await send_msg(json.dumps({'result': f"FAILED REF Input Test"}))
        await mc6.EnablePWMOutput(3,0)
        await mc6.ConfigurePWMOutput(3,0,0,10)
        await asyncio.sleep(.1)
        if mc6test_error == 0:
            await send_msg(json.dumps({'result': f"PASSED REF Input Test"}))
        await mc6.Reset()
        await asyncio.sleep(.1)
        
        #Test EXP Connector
        #Test AIns and PWMs
        mc6 = get_node_endpoint('mc6')
        await init('mc6')
        #Test AIn2 and PWM3
        await mc6.ConfigurePWMOutput(2,1000,1000,10)
        await mc6.EnablePWMOutput(2,1) #enable PWM3 for AIn2
        await asyncio.sleep(.1)
        AIn2_EXP = 0
        AIn2_EXP = (await mc6.GetAnalogInput(2))[0]
        if AIn2_EXP < 0.08 or AIn2_EXP > 0.1:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"AIn2_EXP or PWM2 error"}))
            await send_msg(json.dumps({'result': f"FAILED EXP Connector Test"}))
        await mc6.EnablePWMOutput(2,0)
        await mc6.ConfigurePWMOutput(2,0,0,10)
        
        #Test AIn3 and PWM4
        await mc6.ConfigurePWMOutput(3,1000,1000,10)
        await mc6.EnablePWMOutput(3,1) #enable PWM4 for AIn3
        await asyncio.sleep(.1)
        AIn3_EXP = 0
        AIn3_EXP = (await mc6.GetAnalogInput(3))[0]
        if AIn3_EXP < 0.08 or AIn3_EXP > 0.1:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"AIn3_EXP or PWM2 error"}))
            await send_msg(json.dumps({'result': f"FAILED EXP Connector Test"}))
        await mc6.EnablePWMOutput(3,0)
        await mc6.ConfigurePWMOutput(3,0,0,10)
        await asyncio.sleep(.1)
        await mc6.Reset()
        await asyncio.sleep(.1)
        
        #Test EXP I2C
        mc6 = get_node_endpoint('mc6')
        await init('mc6')
        DispTemp = 256*(await mc6.GetAnalogInput(7))[0]
        if DispTemp < 5 or DispTemp > 50:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"I2C error or ambient temperature not between 5°C and 50 °C"}))
            await send_msg(json.dumps({'result': f"FAILED EXP Connector Test"}))
        if mc6test_error == 0:
            await send_msg(json.dumps({'result': f"PASSED EXP Connector Test"}))
        await mc6.Reset()
        await asyncio.sleep(.1)
        
        #Test SH Connector
        mc6 = get_node_endpoint('mc6')
        await init('mc6')
        await mc6.ConfigurePWMOutput(0,1000,1000,10)
        await mc6.EnablePWMOutput(0,1) #enable PWM1 for I2C ADC
        await asyncio.sleep(.1)
        SPSINR = (await mc6.GetAnalogInput(5))[0]
        if SPSINR < 0.0002 or SPSINR > 0.0003:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"I2C error or PWM1 error"}))
            await send_msg(json.dumps({'result': f"FAILED SH Connector Test"}))
        if mc6test_error == 0:
            await send_msg(json.dumps({'result': f"PASSED SH Connector Test"}))
        
        internalADC = (await mc6.GetAnalogInput(8))[0]
        if internalADC < 0.7 or internalADC > 0.8:
            mc6test_error = 1
            await send_msg(json.dumps({'result': f"Internal ADC error"}))
            await send_msg(json.dumps({'result': f"FAILED Internal ADC Test"}))
        await mc6.EnablePWMOutput(0,0)
        await mc6.ConfigurePWMOutput(0,0,0,10)
        await asyncio.sleep(.1)
        if mc6test_error == 0:
            await send_msg(json.dumps({'result': f"PASSED Internal ADC Test"}))
        await mc6.Reset()

        if mc6test_error == 0:
            await send_msg(json.dumps({'result': f"MC6 test successful. Continue with next DUT."}))
        else:
            await send_msg(json.dumps({'result': f"MC6 test failed. Check error messages."}))

            
        # To support the stop button in ground control, we have to check if it has been pressed and stop by returning.
        if GlobalVar.get_stop_gc():
            return f"MC6_test stopped by user"


    finally:
        # By using a try/finally the power is always switched off when leaving the test function.
        await fmb.SetDigitalOutput(FMBDigitalOutput.PSUON, 1)   # Base Tester Power = OFF (active low)

